/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class GemSetPickaxe
extends PickaxeItem {
    private final float baseAttackSpeed;
    private final float baseAttackDamage;

    public GemSetPickaxe(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.baseAttackSpeed = attackSpeedIn;
        this.baseAttackDamage = (float)attackDamageIn + tier.m_6631_();
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public float getTotalBaseDamage() {
        return this.baseAttackDamage;
    }

    public int getLevelProgress(ItemStack stack) {
        int oresPerLevel = (Integer)GemsNJewelsConfig.COMMON.pickaxeOresPerLevel.get();
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.pickaxeBlocksPerLevel.get();
        double oreCount = 0.0;
        double blockCount = 0.0;
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Ores") && oresPerLevel > 0) {
                oreCount = (double)(nbt.m_128451_("Ores") % oresPerLevel) * (10.0 / (double)oresPerLevel);
            }
            if (nbt.m_128441_("Blocks") && blocksPerLevel > 0) {
                blockCount = (double)(nbt.m_128451_("Blocks") % blocksPerLevel) * (10.0 / (double)blocksPerLevel);
            }
        }
        return (int)Math.floor(oreCount + blockCount);
    }

    public int getCurrentLevel(ItemStack stack) {
        double oreProgress = 0.0;
        double blockProgress = 0.0;
        int oresPerLevel = (Integer)GemsNJewelsConfig.COMMON.pickaxeOresPerLevel.get();
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.pickaxeBlocksPerLevel.get();
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Ores") && oresPerLevel > 0) {
                oreProgress = (double)nbt.m_128451_("Ores") / (double)oresPerLevel;
            }
            if (nbt.m_128441_("Blocks") && blocksPerLevel > 0) {
                blockProgress = (double)nbt.m_128451_("Blocks") / (double)blocksPerLevel;
            }
        }
        return (int)(oreProgress + blockProgress);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean isNamedOre;
        CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        String displayName = new ItemStack((ItemLike)worldIn.m_8055_(pos).m_60734_()).m_41611_().getString();
        boolean bl = isNamedOre = displayName.toLowerCase().equals("[ore]") || displayName.length() > 5 && (displayName.toLowerCase().substring(displayName.length() - 5).equals(" ore]") || displayName.toLowerCase().contains(" ore "));
        if (isNamedOre) {
            if (nbt.m_128441_("Ores")) {
                nbt.m_128405_("Ores", nbt.m_128451_("Ores") + 1);
            } else {
                nbt.m_128405_("Ores", 1);
            }
            stack.m_41751_(nbt);
        } else {
            if (nbt.m_128441_("Blocks")) {
                nbt.m_128405_("Blocks", nbt.m_128451_("Blocks") + 1);
            } else {
                nbt.m_128405_("Blocks", 1);
            }
            stack.m_41751_(nbt);
        }
        if (stack.m_41782_() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int levelProgress = this.getLevelProgress(stack);
            int level = this.getCurrentLevel(stack);
            int randomChance = entityLiving.f_19853_.f_46441_.nextInt(2);
            if (level >= 7 && randomChance == 1) {
                return true;
            }
            if (level >= 3 && !entityLiving.f_19853_.m_5776_()) {
                int j;
                for (int i = entityLiving.f_19853_.f_46441_.nextInt(2) + entityLiving.f_19853_.f_46441_.nextInt(2); i > 0; i -= j) {
                    j = ExperienceOrb.m_20782_((int)i);
                    entityLiving.f_19853_.m_7967_((Entity)new ExperienceOrb(entityLiving.f_19853_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), j));
                }
            }
        }
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlot.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int lvl = this.getCurrentLevel(stack);
        attackSpeedBonus = attackSpeedBonus * (float)lvl / 20.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.baseAttackDamage, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Ores") || stack.m_41783_().m_128441_("Blocks")) {
            int i;
            int oreCount = stack.m_41783_().m_128451_("Ores");
            String ores = "\u00a7e" + Integer.toString(oreCount);
            TextComponent mined = new TextComponent("Ores Mined: " + ores);
            tooltip.add((Component)mined);
            int lvlProgress = this.getLevelProgress(stack);
            int lvl = this.getCurrentLevel(stack);
            String level = "Lvl: " + lvl;
            level = lvl < 5 ? level + " \u00a77Novice" : (lvl < 10 ? level + " \u00a7aAdept" : (lvl < 20 ? level + " \u00a7bHeroic" : (lvl < 30 ? level + " \u00a7dMaster" : (lvl < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            Object progression = "|\u00a7a";
            for (i = 0; i < lvlProgress % 10; ++i) {
                progression = (String)progression + "=";
            }
            progression = (String)progression + "\u00a77";
            for (i = lvlProgress % 10; i < 10; ++i) {
                progression = (String)progression + "-";
            }
            progression = (String)progression + "\u00a7f|";
            TextComponent levelText = new TextComponent(level);
            TextComponent progText = new TextComponent((String)progression);
            tooltip.add((Component)levelText);
            tooltip.add((Component)progText);
            tooltip.add((Component)new TextComponent("\u00a75-Gains bonus swing speed per level"));
            if (lvl >= 3) {
                tooltip.add((Component)new TextComponent("\u00a75-Mining blocks grants experience"));
            }
            if (lvl >= 7) {
                tooltip.add((Component)new TextComponent("\u00a75-Resists tool damage"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent("\u00a77Gains perks from mining blocks"));
        }
    }
}

